/*
 * Decompiled with CFR 0.152.
 */
package com.majruszsenchantments.enchantments;

import com.majruszsenchantments.Registries;
import com.mlib.EquipmentSlots;
import com.mlib.config.ConfigGroup;
import com.mlib.contexts.OnDeath;
import com.mlib.contexts.OnEnchantmentAvailabilityCheck;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.ModConfigs;
import com.mlib.enchantments.CustomEnchantment;
import com.mlib.entities.EntityHelper;
import com.mlib.modhelper.AutoInstance;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;

public class ImmortalityEnchantment
extends CustomEnchantment {
    public ImmortalityEnchantment() {
        this.rarity(Enchantment.Rarity.RARE).category(Registries.SHIELD).slots(EquipmentSlots.BOTH_HANDS).minLevelCost(level -> 20).maxLevelCost(level -> 50);
    }

    @AutoInstance
    public static class Handler {
        final Supplier<ImmortalityEnchantment> enchantment = Registries.IMMORTALITY;

        public Handler() {
            ConfigGroup group = ModConfigs.registerSubgroup((String)Registries.Groups.ENCHANTMENT).name("Immortality").comment("Cheats death on a fatal hit at the cost of this enchantment.");
            OnEnchantmentAvailabilityCheck.listen((Consumer)OnEnchantmentAvailabilityCheck.ENABLE).addCondition(OnEnchantmentAvailabilityCheck.is(this.enchantment)).addCondition(OnEnchantmentAvailabilityCheck.excludable()).insertTo(group);
            OnDeath.listen(this::cancelDeath).addCondition(Condition.isServer()).addCondition(Condition.hasEnchantment(this.enchantment, data -> data.target)).insertTo(group);
        }

        private void cancelDeath(OnDeath.Data data) {
            LivingEntity target = data.target;
            InteractionHand hand = this.enchantment.get().hasEnchantment(target.m_21205_()) ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND;
            this.enchantment.get().removeEnchantment(target.m_21120_(hand));
            EntityHelper.cheatDeath((LivingEntity)target, (float)1.0f, (boolean)true);
            data.event.setCanceled(true);
        }
    }
}

